package benchmarks;

import java.io.IOException;

import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.IncrementalIdStrategy;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import com.esotericsoftware.kryo.Kryo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.google.gson.Gson;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;

import edu.vub.at.actors.natives.Packet;
import edu.vub.at.exceptions.InterpreterException;
import edu.vub.at.objects.ATAbstractGrammar;
import edu.vub.at.objects.ATObject;
import edu.vub.at.objects.ATTypeTag;
import edu.vub.at.objects.coercion.NativeTypeTags;
import edu.vub.at.objects.natives.NATNumber;
import edu.vub.at.objects.natives.NATObject;
import edu.vub.at.objects.natives.NATText;
import edu.vub.at.objects.natives.grammar.AGAssignField;
import edu.vub.at.objects.natives.grammar.AGSymbol;
import edu.vub.at.parser.NATParser;

public class TestClasses {

	public static NATText boeTXT;
	public static NATText fooTXT;
	
	public static AGSymbol fooSYM;
	public static AGAssignField ass;

	public static ATAbstractGrammar ag;
	public static Packet p;
	
	public static ATObject isolate;
	
	public static ATObject[] isolatePair = {isolate,isolate};

	public static byte[] serializedBoeTXT;
	
	public static byte[] serializedAss;
	
	public static byte[] serializedAG;
	
	public static byte[] serializedIsolate;
	
	public static byte[] serializedIsolateRefPair;
	
	
	public TestClasses() throws InterpreterException, IOException {
		boeTXT = NATText.atValue("boe");
		fooTXT = NATText.atValue("Foo");

		fooSYM = AGSymbol.jAlloc("foo");
		ass = new AGAssignField(boeTXT, fooSYM, fooTXT);
		
		

		ag = NATParser.parse("test", "{ |x,y| x + y }");
		//p = new Packet("test", ag);
		//p.unpack();
		
		isolate = new NATObject(new ATTypeTag[] { NativeTypeTags._ISOLATE_});
		isolate.meta_defineField(AGSymbol.jAlloc("x"), NATText.atValue("boe"));
		isolate.meta_defineField(AGSymbol.jAlloc("y"), NATNumber.atValue(2));
		
		}
}